#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <LittleFS.h>
#include <vector>
#include <algorithm>

const char* ssid="asajah";
const char* pass="xxxxxxxx";

bool systemFolder = true;
bool coreFolder   = true;

AsyncWebServer server(80);


/* ================= REKURZÍV KÖNYVTÁR MÉRET ================= */
size_t dirSize(const String &path){
    size_t total = 0;
    File f = LittleFS.open(path);
    if(!f) return 0;
    if(!f.isDirectory()){ total = f.size(); f.close(); return total; }

    File sub = f.openNextFile();
    while(sub){
        String name = String(sub.name());
        if(sub.isDirectory()) total += dirSize(name);
        else total += sub.size();
        sub.close();
        sub = f.openNextFile();
    }
    f.close();
    return total;
}


/* ================= SETUP ================= */
void setup(){
 Serial.begin(115200);
 LittleFS.begin(true);

 WiFi.mode(WIFI_STA);
 WiFi.config(IPAddress(192,168,0,88),IPAddress(192,168,0,1),IPAddress(255,255,255,0));
 WiFi.begin(ssid,pass);
 while(WiFi.status()!=WL_CONNECTED){ delay(200); yield(); }

 server.serveStatic("/",LittleFS,"/");

 struct Entry{String name;bool dir;size_t size;};

 server.on("/", HTTP_GET, [](AsyncWebServerRequest *r){
    r->redirect("/index.html");
 });
 

 server.on("/list",HTTP_POST,[](AsyncWebServerRequest*r){
  String path="/";
  if(r->hasParam("path",true)) path=r->getParam("path",true)->value();
  File dir=LittleFS.open(path);
  if(!dir||!dir.isDirectory()){ r->send(200,"application/json","[]"); return; }

  std::vector<Entry> v;
  File x=dir.openNextFile();
  while(x){
   String n=String(x.name()).substring(String(x.name()).lastIndexOf('/')+1);
   size_t sz = x.isDirectory() ? dirSize(path + (path.endsWith("/")?"":"/") + n) : x.size();
   v.push_back({n,x.isDirectory(), sz});
   x=dir.openNextFile();
  }

  // Rendezés: core, system, egyéb könyvtárak, fájlok, ABC kis-nagybetűt figyelmen kívül
  auto cmp=[](const Entry &a, const Entry &b){
      // core első
      if(a.name.equalsIgnoreCase("core")) return true;
      if(b.name.equalsIgnoreCase("core")) return false;

      // system második
      if(a.name.equalsIgnoreCase("system")) return true;
      if(b.name.equalsIgnoreCase("system")) return false;

      // könyvtárak előrébb, fájlok hátrébb
      if(a.dir && !b.dir) return true;
      if(!a.dir && b.dir) return false;

      // ABC sorrend kis-nagybetűt figyelmen kívül hagyva
      String A = a.name; A.toLowerCase();
      String B = b.name; B.toLowerCase();
      return A < B;
  };
  std::sort(v.begin(), v.end(), cmp);

  String j="[";
  for(size_t i=0;i<v.size();i++){
   if(i) j+=",";
   j+="{\"name\":\""+v[i].name+"\",\"dir\":"+(v[i].dir?"true":"false")+",\"size\":"+String(v[i].size)+"}";
  }
  j+="]";
  r->send(200,"application/json",j);
 });

 server.on("/flashfree",HTTP_GET,[](AsyncWebServerRequest*r){
  r->send(200,"application/json",
   "{\"total\":"+String(LittleFS.totalBytes()/1024)+",\"used\":"+String(LittleFS.usedBytes()/1024)+"}");
 });

 server.on("/upload",HTTP_POST,
 [](AsyncWebServerRequest*r){ r->send(200); },
 NULL,
 [](AsyncWebServerRequest*r,uint8_t*d,size_t l,size_t i,size_t t){
  static File file;
  if(i==0){
   if(file)file.close();
   if(!r->hasParam("path")||!r->hasParam("name")) return;
   String p=r->getParam("path")->value();
   if(!p.endsWith("/"))p+="/";
   file=LittleFS.open(p+r->getParam("name")->value(),"w");
  }
  if(file) file.write(d,l);
  if(i+l==t && file) file.close();
 });

 server.on("/mkdir",HTTP_POST,[](AsyncWebServerRequest*r){ r->send(LittleFS.mkdir(r->getParam("path",true)->value())?200:500); });
 server.on("/delete",HTTP_POST,[](AsyncWebServerRequest*r){ r->send(rm_rf(r->getParam("path",true)->value())?200:500); });
 server.on("/rename",HTTP_POST,[](AsyncWebServerRequest*r){ r->send(LittleFS.rename(r->getParam("old",true)->value(),r->getParam("new",true)->value())?200:500); });

 server.on("/core/editor.html",HTTP_POST,[](AsyncWebServerRequest*r){
  String path="";
  if(r->hasParam("path",true)) path=r->getParam("path",true)->value();
  File f=LittleFS.open("/core/editor.html","r");
  if(!f){ r->send(404); return; }
  String h=f.readString(); f.close();
  h.replace("<!--INSERT_PATH_HERE-->",path);
  r->send(200,"text/html",h);
 });

 server.begin();
}



/* ================= REKURZÍV TÖRLÉS ================= */
bool rm_rf(const String &path){
  // Nyissuk meg a könyvtárat
  File dir = LittleFS.open(path);
  if(!dir) return false;

  // Ha fájl → törlés
  if(!dir.isDirectory()){
    dir.close();
    return LittleFS.remove(path);
  }

  // Könyvtár: gyűjtsük össze a tartalmat
  std::vector<String> items;
  File f = dir.openNextFile();
  while(f){
    String name = String(f.name());
    if(!name.startsWith("/")) name = path + "/" + name; // teljes path
    items.push_back(name);
    f.close();
    f = dir.openNextFile();
  }
  dir.close();

  // Tartalom törlése
  for(const String &p : items){
    File x = LittleFS.open(p);
    if(x && x.isDirectory()){
      x.close();
      rm_rf(p);
    } else {
      if(x) x.close();
      LittleFS.remove(p);
    }
    yield(); // ESP watchdog + FS flush
  }

  // Végül töröljük a könyvtárat
  return LittleFS.rmdir(path);
}

void loop(){}
