
//v004

#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <LittleFS.h>
#include <vector>
#include <algorithm>

#include <filemanager.h>

const char* ssid="asajah";
const char* pass="xxxxxxxx";


bool systemFolder = true;
bool coreFolder = true;

AsyncWebServer server(80);


/* ================= SETUP ================= */
void setup(){
    Serial.begin(115200);
    LittleFS.begin(true);

    WiFi.mode(WIFI_STA);
    WiFi.config(IPAddress(192,168,0,88),IPAddress(192,168,0,1),IPAddress(255,255,255,0));
    WiFi.begin(ssid,pass);
    while(WiFi.status()!=WL_CONNECTED){ delay(200); yield(); }

    server.serveStatic("/",LittleFS,"/");

    server.on("/", HTTP_GET, [](AsyncWebServerRequest *r){
        r->redirect("/index.html");
    });

    server.on("/raw", HTTP_GET, [](AsyncWebServerRequest *request){
      request->send(200, "text/html", raw_upload_html);
    });


    server.on("/list", HTTP_POST, handleList);
    server.on("/list_s", HTTP_POST, handleListSafe);
    server.on("/flashfree", HTTP_GET, handleFlashFree);
    server.on("/upload", HTTP_POST, [](AsyncWebServerRequest *r){ r->send(200); }, NULL, handleUpload);
    server.on("/download", HTTP_POST, handleDownload);
    server.on("/format", HTTP_POST, handleFormat);
    server.on("/mkdir", HTTP_POST, handleMkdir);
    server.on("/delete", HTTP_POST, handleDelete);
    server.on("/rename", HTTP_POST, handleRename);
    server.on("/core/admin/editor.html", HTTP_POST, handleEditor);
    server.begin();
}


void loop(){}
