
function setCrossed(id, isCrossed) {
    const img = document.getElementById(id);
    
    if (!img) {
        console.warn(`setCrossed: A(z) "${id}" azonosítóval nem található elem!`);
        return;
    }

    let wrapper = img.parentElement;
    
    // Ellenőrizzük, hogy már be van-e csomagolva
    if (!wrapper || !wrapper.classList.contains('icon-wrapper')) {
        wrapper = document.createElement('div');
        wrapper.className = 'icon-wrapper';
        img.parentNode.insertBefore(wrapper, img);
        wrapper.appendChild(img);
    }

    let overlay = wrapper.querySelector('.crossed-overlay');

    if (isCrossed) {
        if (!overlay) {
            overlay = document.createElement('img');
            // Vastag, extra piros X SVG
            overlay.src = "data:image/svg+xml;base64,PHN2ZyB4bWxucz0iaHR0cDovL3d3dy53My5vcmcvMjAwMC9zdmciIHZpZXdCb3g9IjAgMCA0OCA0OCI+PHBhdGggZD0iTTM4IDExLjRMMzYuNiAxMCAyNCAyMi42IDExLjQgMTAgMTAgMTEuNCAyMi42IDI0IDEwIDM2LjZsMS40IDEuNCAxMi42LTEyLjYgMTIuNiAxMi42IDEuNC0xLjRMMjUuNCAyNHoiIGZpbGw9InJlZCIgc3Ryb2tlPSJyZWQiIHN0cm9rZS13aWR0aD0iMiIvPjwvc3ZnPg==";
            overlay.className = 'crossed-overlay';
            wrapper.appendChild(overlay);
        }
    } else {
        if (overlay) {
            overlay.remove();
        }
    }
}