
//v003

#include <Arduino.h>
#include <WiFi.h>
#include <AsyncTCP.h>
#include <ESPAsyncWebServer.h>
#include <LittleFS.h>
#include <vector>
#include <algorithm>

#include <filemanager.h>

const char* ssid="asajah";
const char* pass="xxxxxxxx";


bool systemFolder = true;
bool coreFolder = true;

AsyncWebServer server(80);


/* ================= SETUP ================= */
void setup(){
    Serial.begin(115200);
    LittleFS.begin(true);

    WiFi.mode(WIFI_STA);
    WiFi.config(IPAddress(192,168,0,88),IPAddress(192,168,0,1),IPAddress(255,255,255,0));
    WiFi.begin(ssid,pass);
    while(WiFi.status()!=WL_CONNECTED){ delay(200); yield(); }

    server.serveStatic("/",LittleFS,"/");

    struct Entry{String name;bool dir;size_t size;};

    server.on("/", HTTP_GET, [](AsyncWebServerRequest *r){
        r->redirect("/index.html");
    });

    server.on("/raw", HTTP_GET, [](AsyncWebServerRequest *request){
      request->send(200, "text/html", raw_upload_html);
    });


extern bool systemFolder;
extern bool coreFolder;

server.on("/list", HTTP_POST, [](AsyncWebServerRequest *r) {
    String path = "/";
    if (r->hasParam("path", true)) path = r->getParam("path", true)->value();

    File dir = LittleFS.open(path);
    if (!dir || !dir.isDirectory()) {
        r->send(200, "application/json", "[]");
        return;
    }

    std::vector<Entry> v;

    File x = dir.openNextFile();
    while (x) {
        String fullName = String(x.name());
        String n = fullName.substring(fullName.lastIndexOf('/') + 1);

        // 🔥 1) LittleFS néha visszaad ".." → mindig szűrjük
        if (n == "..") {
            x.close();
            x = dir.openNextFile();
            continue;
        }

        // 🔥 2) core/system tiltása rootban
        if (path == "/") {
            if (!coreFolder && n == "core") {
                x.close();
                x = dir.openNextFile();
                continue;
            }
            if (!systemFolder && n == "system") {
                x.close();
                x = dir.openNextFile();
                continue;
            }
        }

        size_t sz = x.isDirectory() ? dirSize(x) : x.size();
        v.push_back({n, x.isDirectory(), sz});

        x.close();
        x = dir.openNextFile();
    }

    // 🔥 3) Rendezés (eredeti logika)
    auto cmp = [](const Entry &a, const Entry &b) {
        if (a.name.equalsIgnoreCase("core")) return true;
        if (b.name.equalsIgnoreCase("core")) return false;
        if (a.name.equalsIgnoreCase("system")) return true;
        if (b.name.equalsIgnoreCase("system")) return false;

        if (a.dir && !b.dir) return true;
        if (!a.dir && b.dir) return false;

        String A = a.name; A.toLowerCase();
        String B = b.name; B.toLowerCase();
        return A < B;
    };

    std::sort(v.begin(), v.end(), cmp);

    // 🔥 4) JSON
    String j = "[";
    for (size_t i = 0; i < v.size(); i++) {
        if (i) j += ",";
        j += "{\"name\":\"" + v[i].name +
             "\",\"dir\":" + (v[i].dir ? "true" : "false") +
             ",\"size\":" + String(v[i].size) + "}";
    }
    j += "]";

    r->send(200, "application/json", j);
});




 server.on("/list_s", HTTP_POST, [](AsyncWebServerRequest *r) {
    String path = "/";
    if (r->hasParam("path", true))
        path = r->getParam("path", true)->value();
    File dir = LittleFS.open(path);
    if (!dir || !dir.isDirectory()) {
        r->send(200, "application/json", "[]");
        return;
    }
    std::vector<Entry> v;
    while (true) {
        File f = dir.openNextFile();
        if (!f) break;
        const char *raw = f.name();
        if (!raw) { f.close(); continue; }
        bool valid = true;
        for (int i = 0; i < 128; i++) {
            char c = raw[i];
            if (c == 0) break;
            if (c < 32 || c > 126) { valid = false; break; }
        }
        if (!valid) { f.close(); continue; }
        String full = String(raw);
        int idx = full.lastIndexOf('/');
        if (idx < 0) idx = -1;
        String name = full.substring(idx + 1);
        if (name.length() == 0) { f.close(); continue; }
        bool isDir = false;
        if (f) {
            isDir = f.isDirectory();
        }
        size_t sz = 0;
        if (!isDir && f) {
            sz = f.size();
        }

        v.push_back({name, isDir, sz});
        f.close();
    }
    auto cmp = [](const Entry &a, const Entry &b) {
        if (a.dir != b.dir) return a.dir; // dirs first
        String A = a.name; A.toLowerCase();
        String B = b.name; B.toLowerCase();
        return A < B;
    };
    std::sort(v.begin(), v.end(), cmp);
    String j = "[";
    for (size_t i = 0; i < v.size(); i++) {
        if (i) j += ",";
        j += "{\"name\":\"" + v[i].name +
             "\",\"dir\":" + (v[i].dir ? "true" : "false") +
             ",\"size\":" + String(v[i].size) + "}";
    }
    j += "]";
    r->send(200, "application/json", j);
});


    server.on("/flashfree",HTTP_GET,[](AsyncWebServerRequest*r){
        r->send(200,"application/json",
            "{\"total\":"+String(LittleFS.totalBytes()/1024)+",\"used\":"+String(LittleFS.usedBytes()/1024)+"}");
    });



server.on("/upload", HTTP_POST,
    [](AsyncWebServerRequest *r){
        r->send(200);
    },
NULL,
    [](AsyncWebServerRequest *r, uint8_t *d, size_t l, size_t i, size_t t){

        // Első chunk → létrehozzuk a TarExtractort és eltároljuk a requestben
        if (i == 0) {
            String name = r->getParam("name")->value();
            String path = r->getParam("path")->value();
            if (!path.endsWith("/")) path += "/";

            // Új TarExtractor példány
            TarExtractor *tar = new TarExtractor();
            tar->begin(name);

            // Eltároljuk a requestben
            r->_tempObject = tar;

            // Ha nem tar → sima fájl
            if (!name.endsWith(".tar")) {
                File *f = new File();
                *f = LittleFS.open(path + name, "w");
//                r->addInterestingHeader("X-File");
                r->_tempFile = *f;
            }
        }

        // Lekérjük a TarExtractort
        TarExtractor *tar = (TarExtractor*) r->_tempObject;

        // Ha tar → feldolgozzuk
        if (tar && tar->isEnabled()) {
            tar->processChunk(d, l);
        } else {
            // Sima fájl
            if (r->_tempFile) {
                r->_tempFile.write(d, l);
            }
        }

        // Utolsó chunk → lezárás és takarítás
        if (i + l == t) {
            if (tar && tar->isEnabled()) {
                delete tar;
            } else {
                if (r->_tempFile) {
                    r->_tempFile.close();
                }
            }
        }
    }
);









    server.on("/flashfree",HTTP_GET,[](AsyncWebServerRequest*r){
        r->send(200,"application/json",
            "{\"total\":"+String(LittleFS.totalBytes()/1024)+",\"used\":"+String(LittleFS.usedBytes()/1024)+"}");
    });

    server.on("/upload", HTTP_POST,
        [](AsyncWebServerRequest *r){
            r->send(200);
        },
    NULL,
    [](AsyncWebServerRequest *r, uint8_t *d, size_t l, size_t i, size_t t){
        static File file;
        static String fullPath;
        Serial.println("upload start");
        if(i == 0){
            if(file) file.close();
            fullPath = "";
            if(!r->hasParam("path") || !r->hasParam("name")) return;
            String p = r->getParam("path")->value();
            if(!p.endsWith("/")) p += "/";
            String n = r->getParam("name")->value();
            fullPath = p + n;
            file = LittleFS.open(fullPath, "w");
        }
        if(file) file.write(d, l);
        if(i + l == t){
            if(file){
                file.close();
                Serial.print(F("UPLOAD OK: "));
                Serial.println(fullPath);
            }
        }
    }
);



server.on("/download", HTTP_POST, [](AsyncWebServerRequest *request) {

    Serial.println("---- /download called ----");

    if (!request->hasParam("path", true)) {
        Serial.println("Missing path");
        request->send(400, "text/plain", "Missing path");
        return;
    }

    String path = request->getParam("path", true)->value();
    Serial.print("Requested path: ");
    Serial.println(path);

    // ===== ROOT: FULL FS TAR =====
    if (path == "/") {
        Serial.println("Full FS TAR requested");
        TarResponse *response = new TarResponse("/");
        response->addHeader("Content-Disposition",
                            "attachment; filename=\"fullFS.tar\"");
        request->send(response);
        return;
    }

    // ===== NORMAL PATH =====
    if (!LittleFS.exists(path)) {
        Serial.println("Path does not exist");
        request->send(404, "text/plain", "Not found");
        return;
    }

    File f = LittleFS.open(path);
    bool isDir = f.isDirectory();
    Serial.print("Is directory: ");
    Serial.println(isDir ? "YES" : "NO");
    f.close();

    if (!isDir) {
        Serial.println("Sending normal file...");
        request->send(LittleFS, path, "application/octet-stream", true);
        return;
    }

    Serial.println("Creating TarResponse...");

    String base = path.substring(path.lastIndexOf('/') + 1);
    if (base == "") base = "root"; // safety

    TarResponse *response = new TarResponse(path);
    response->addHeader("Content-Disposition",
                        "attachment; filename=\"" + base + ".tar\"");

    Serial.println("Sending TarResponse...");
    request->send(response);
});



server.on("/format", HTTP_POST, [](AsyncWebServerRequest *r) {
    // Biztonsági megerősítés
    if (!r->hasParam("confirm", true) ||
        r->getParam("confirm", true)->value() != "YES") {
        r->send(400, "application/json",
                "{\"ok\":false,\"error\":\"CONFIRM_REQUIRED\",\"msg\":\"Add confirm=YES to format FS\"}");
        return;
    }

    // Formázás
    bool ok = LittleFS.format();
    if (!ok) {
        r->send(500, "application/json",
                "{\"ok\":false,\"error\":\"FORMAT_FAILED\"}");
        return;
    }

    // Újra mountoljuk
    if (!LittleFS.begin(true)) {
        r->send(500, "application/json",
                "{\"ok\":false,\"error\":\"MOUNT_FAILED_AFTER_FORMAT\"}");
        return;
    }

    // Kötelező könyvtárak létrehozása
    LittleFS.mkdir("/core");
    LittleFS.mkdir("/system");

    // Ellenőrzés
    File c = LittleFS.open("/core");
    File s = LittleFS.open("/system");

    if (!c || !c.isDirectory() || !s || !s.isDirectory()) {
        r->send(500, "application/json",
                "{\"ok\":false,\"error\":\"DIR_CREATE_FAILED\"}");
        return;
    }

    r->send(200, "application/json",
            "{\"ok\":true,\"msg\":\"FS formatted and core/system created\"}");
});




    server.on("/mkdir",HTTP_POST,[](AsyncWebServerRequest*r){ r->send(LittleFS.mkdir(r->getParam("path",true)->value())?200:500); });
    server.on("/delete",HTTP_POST,[](AsyncWebServerRequest*r){ r->send(rm_rf(r->getParam("path",true)->value())?200:500); });
    server.on("/rename",HTTP_POST,[](AsyncWebServerRequest*r){ r->send(LittleFS.rename(r->getParam("old",true)->value(),r->getParam("new",true)->value())?200:500); });

    server.on("/core/admin/editor.html",HTTP_POST,[](AsyncWebServerRequest*r){
        String path="";
        if(r->hasParam("path",true)) path=r->getParam("path",true)->value();
        File f=LittleFS.open("/core/admin/editor.html","r");
        if(!f){ r->send(404); return; }
        String h=f.readString(); f.close();
        h.replace("<!--INSERT_PATH_HERE-->",path);
        r->send(200,"text/html",h);
    });

    server.begin();
}


/* ================= REKURZÍV TÖRLÉS ================= */
bool rm_rf(const String &path){
    File dir = LittleFS.open(path);
    if(!dir) return false;

    if(!dir.isDirectory()){
        dir.close();
        return LittleFS.remove(path);
    }

    std::vector<String> items;
    File f = dir.openNextFile();
    while(f){
        String name = String(f.name());
        if(!name.startsWith("/")) name = path + "/" + name;
        items.push_back(name);
        f.close();
        f = dir.openNextFile();
    }
    dir.close();

    for(const String &p : items){
        File x = LittleFS.open(p);
        if(x && x.isDirectory()){
            x.close();
            rm_rf(p);
        } else {
            if(x) x.close();
            LittleFS.remove(p);
        }
        yield();
    }

    return LittleFS.rmdir(path);
}

void loop(){}
